//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Message_Form.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"

#define MAX_BUTTON_COUNT		4
#define TEXT_BLANK				50
#define MIN_FORM_SIZE			360
#define BUTTON_WIDTH			92
#define BUTTON_GAP				8

TMessageForm *MessageForm;
//---------------------------------------------------------------------------
__fastcall TMessageForm::TMessageForm(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
int __fastcall TMessageForm::MessageDlg(const AnsiString Msg, TMsgDlgType DlgType, TMsgDlgButtons Buttons)
{
	int buttonCount = 0;
	TBitBtn *buttonComponents[MAX_BUTTON_COUNT];

	MessageLabel->Caption = Msg;
	OKBitBtn->Visible = false;
	CancelBitBtn->Visible = false;

	if (Buttons.Contains(mbOK))
	{
		buttonComponents[buttonCount] = OKBitBtn;
		buttonCount++;
	}
	if (Buttons.Contains(mbCancel))
	{
		buttonComponents[buttonCount] = CancelBitBtn;
		buttonCount++;
	}

	int formWidth = MessageLabel->Canvas->TextWidth(Msg) + 2 * TEXT_BLANK;
	if (formWidth < MIN_FORM_SIZE) formWidth = MIN_FORM_SIZE;

	this->Width = formWidth;
	WaitingProgressBar->Width = formWidth - 100;
	WaitingProgressBar->Left = 50;
	MessageLabel->Left = (formWidth - MessageLabel->Canvas->TextWidth(Msg)) / 2;
	if (WaitingProgressBar->Visible)
	{
		this->Height = 190;
	}
	else
	{
		this->Height = 150;
	}

	int buttonTotalWidth = buttonCount * BUTTON_WIDTH + (buttonCount - 1) * BUTTON_GAP;
	int buttonLeft = (formWidth - buttonTotalWidth) / 2;
	for (int buttonIndex = 0; buttonIndex < buttonCount; buttonIndex++)
	{
		buttonComponents[buttonIndex]->Left = buttonLeft;
		buttonComponents[buttonIndex]->Visible = true;
		buttonLeft += (BUTTON_WIDTH + BUTTON_GAP);
		if (WaitingProgressBar->Visible)
		{
			buttonComponents[buttonIndex]->Top = 80;
		}
		else
		{
			buttonComponents[buttonIndex]->Top = 40;
		}
	}

	if (buttonCount == 0)
	{
		this->Height = this->Height - 80;
	}

	this->Position = poScreenCenter;
	return this->ShowModal();
}
//---------------------------------------------------------------------------
int __fastcall TMessageForm::WaitingDlg(const AnsiString Msg, int WaitingTime, TMsgDlgType DlgType, TMsgDlgButtons Buttons)
{
	int modalResult;
	//	WaitingTimer->Interval = WaitingTime;
	CloseWaitingTime = WaitingTime;
	ShowTime = GetTickCount();
	WaitingProgressBar->Position = 0;
	WaitingProgressBar->Max = WaitingTime;
	WaitingProgressBar->Visible = true;
	WaitingTimer->Enabled = true;
	modalResult = this->MessageDlg(Msg, DlgType, Buttons);
	return modalResult;
}
//---------------------------------------------------------------------------
int __fastcall MessageDlgFA(const AnsiString Msg, TMsgDlgType DlgType, TMsgDlgButtons Buttons)
{
	int result;
	TMessageForm *messageForm = new TMessageForm(Application);
	result = messageForm->MessageDlg(Msg, DlgType, Buttons);
	delete messageForm;
	return result;
}
//---------------------------------------------------------------------------
int __fastcall WaitingDlgFA(const AnsiString Msg, int WaitingTime, TMsgDlgType DlgType, TMsgDlgButtons Buttons)
{
	int result;
	TMessageForm *messageForm = new TMessageForm(Application);
	result = messageForm->WaitingDlg(Msg, WaitingTime, DlgType, Buttons);
	delete messageForm;
	return result;
}
//---------------------------------------------------------------------------
void __fastcall ShowMessageFA(const AnsiString Msg)
{
	TMessageForm *messageForm = new TMessageForm(Application);
	messageForm->MessageDlg(Msg, mtInformation, TMsgDlgButtons() << mbOK);
	delete messageForm;
}
//---------------------------------------------------------------------------
void __fastcall TMessageForm::WaitingTimerTimer(TObject *Sender)
{
	if (GetTickCount() - ShowTime >= CloseWaitingTime)
	{
		WaitingProgressBar->Position = WaitingProgressBar->Max;
		WaitingProgressBar->Visible = false;
		WaitingTimer->Enabled = false;
		ModalResult = mrOk;
	}
	else
	{
		WaitingProgressBar->Position = (GetTickCount() - ShowTime);
	}
}
//---------------------------------------------------------------------------
void __fastcall TMessageForm::OKBitBtnClick(TObject *Sender)
{
	WaitingProgressBar->Visible = false;
	WaitingTimer->Enabled = false;
}
//---------------------------------------------------------------------------
void __fastcall TMessageForm::CancelBitBtnClick(TObject *Sender)
{
	WaitingProgressBar->Visible = false;
	WaitingTimer->Enabled = false;
}
//---------------------------------------------------------------------------

